package usb4allConfigGenerator;

import java.util.Vector;

public class Interface {
	
	private static final String ls = System.getProperty("line.separator");
		
	private int alternateSettingNumber;
	private int classCode;
	private int subClassCode;
	private int protocolCode;
	private int interfaceStringIndex;
	private Vector<Endpoint> endpoints;
	
	public Vector<Endpoint> getEndpoints() {
		return endpoints;
	}

	//USB_INTF_DSC            i00a00;                 \
	public String generateDescriptorH(int interfaceNumber){
		StringBuffer sb = new StringBuffer();
		sb.append("    USB_INTF_DSC            "+getInum(interfaceNumber)+";	\\"+ls);
		
		//agrego endpoints de la interfaz
		for(int i=0;i<endpoints.size();i++){
			if (i!=0) sb.append(";	\\"+ls);
			sb.append(endpoints.elementAt(i).generateDescriptorH(interfaceNumber));
		}
		return sb.toString();
	}
	
	private String getInum(int interfaceNumber){
		//TODO arreglar para cuando haya interfaces alternativas
		if (interfaceNumber<10) return "i0"+interfaceNumber+"a00";
		else return "i"+interfaceNumber+"a00";
	}
	
	public String generateDescriptorC(int interfaceNumber){
		StringBuffer sb = new StringBuffer();
		
		sb.append("// Interface Descriptor" + ls +
				"sizeof(USB_INTF_DSC),   // Size of this descriptor in bytes" + ls +
				"DSC_INTF,               // INTERFACE descriptor type" + ls +
				interfaceNumber + ",                      // Interface Number" + ls +
				alternateSettingNumber+ ",                      // Alternate Setting Number" + ls +
				endpoints.size()+",                      // Number of endpoints in this intf" + ls +
				"0x"+Integer.toHexString(classCode)+",                   // Class code" + ls +
				"0x"+Integer.toHexString(subClassCode)+",                   // Subclass code" + ls +
				"0x"+Integer.toHexString(protocolCode)+",                   // Protocol code" + ls +
				interfaceStringIndex+ ",                      // Interface string index"+ls+ls+
				"//				 Endpoint Descriptors"+ls);
		
		//agrego endpoints de la interfaz
		for(int i=0;i<endpoints.size();i++){
			if (i!=0) sb.append(","+ls);
			sb.append(endpoints.elementAt(i).generateDescriptorC());
		}
		
				
		return sb.toString();
	}

	public Interface(int alternateSettingNumber, int classCode, int subClassCode, int protocolCode, int interfaceStringIndex) {
		super();
		// TODO Auto-generated constructor stub
		this.alternateSettingNumber = alternateSettingNumber;
		this.classCode = classCode;
		this.subClassCode = subClassCode;
		this.protocolCode = protocolCode;
		this.interfaceStringIndex = interfaceStringIndex;
		endpoints = new Vector<Endpoint>(); 
	}
	
	public void addEndpoint(Endpoint ep){
		endpoints.add(ep);
	}
	
	/*
    // Interface Descriptor 
    sizeof(USB_INTF_DSC),   // Size of this descriptor in bytes
    DSC_INTF,               // INTERFACE descriptor type
    0,                      // Interface Number
    0,                      // Alternate Setting Number
    4,                      // Number of endpoints in this intf
    0x00,                   // Class code
    0x00,                   // Subclass code
    0x00,                   // Protocol code
    0,                      // Interface string index
    
    // Endpoint Descriptors 
    sizeof(USB_EP_DSC),DSC_EP,_EP01_OUT,_INT,USBGEN_EP_SIZE,32,
    sizeof(USB_EP_DSC),DSC_EP,_EP01_IN,_INT,USBGEN_EP_SIZE,32,
	sizeof(USB_EP_DSC),DSC_EP,_EP02_OUT,_BULK,BOOT_EP_SIZE,64,
    sizeof(USB_EP_DSC),DSC_EP,_EP02_IN,_BULK,BOOT_EP_SIZE,64
*/
}
